async function previewCourse() {
    if (!selectedFile) {
        showStatus('Please select a file first.', 'error');
        return;
    }
    
    // Create FormData
    const formData = new FormData();
    formData.append('courseFile', selectedFile);
    
    // Show loading state
    previewPlaceholder.innerHTML = `
        <div class="preview-icon" style="color: #007bff;">
            ⏳
        </div>
        <h3>Uploading & Processing...</h3>
        <p>Please wait while we upload and extract your course.</p>
        <div class="loader" style="margin-top: 20px;"></div>
    `;
    
    previewPlaceholder.style.display = 'flex';
    previewFrame.style.display = 'none';
    
    showStatus('Uploading file to server...', 'loading');
    
    try {
        // Upload to server
        const response = await fetch('upload.php', {
            method: 'POST',
            body: formData
        });
        
        const result = await response.json();
        
        if (result.success) {
            showStatus('Course uploaded successfully!', 'success');
            
            // Load the course in iframe
            previewFrame.src = result.previewUrl;
            previewPlaceholder.style.display = 'none';
            previewFrame.style.display = 'block';
            
        } else {
            showStatus('Error: ' + result.message, 'error');
            previewPlaceholder.innerHTML = `
                <div class="preview-icon" style="color: #dc3545;">
                    ❌
                </div>
                <h3>Upload Failed</h3>
                <p>${result.message}</p>
                <button class="btn" onclick="clearFile()" style="margin-top: 20px;">
                    Try Again
                </button>
            `;
        }
        
    } catch (error) {
        showStatus('Network error: ' + error.message, 'error');
        previewPlaceholder.innerHTML = `
            <div class="preview-icon" style="color: #dc3545;">
                ❌
            </div>
            <h3>Upload Failed</h3>
            <p>Unable to connect to server. Please try again.</p>
            <button class="btn" onclick="showSampleCourse()" style="margin-top: 20px;">
                View Sample Course Instead
            </button>
        `;
    }
}